<?php

//admin/controller/shipping
class ControllerExtensionShippingChronepostpickuppt extends Controller
{
	private $error = array();

	public function index()
	{
		$this->language->load('extension/shipping/chronepostpickuppt');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			//print_r($this->request->post);

			//die;
			$this->model_setting_setting->editSetting('shipping_chronepostpickuppt', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/shipping/chronepostpickuppt', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_none'] = $this->language->get('text_none');

		$data['entry_cost'] = $this->language->get('entry_cost');
		$data['entry_freelimit'] = $this->language->get('entry_freelimit');
		$data['entry_tax_class'] = $this->language->get('entry_tax_class');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_refresh'] = $this->language->get('button_refresh');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['entry_weight_from'] = $this->language->get('entry_weight_from');
		$data['entry_weight_from_tooltip'] = $this->language->get('entry_weight_from_tooltip');
		$data['entry_weight_to'] = $this->language->get('entry_weight_to');
		$data['entry_weight_to_tooltip'] = $this->language->get('entry_weight_to_tooltip');
		$data['entry_first'] = $this->language->get('entry_first');
		$data['entry_next'] = $this->language->get('entry_next');

		$data['button_remove'] = $this->language->get('button_remove');
		$data['button_add'] = $this->language->get('button_add');


		$data['refresh_data_href'] = $this->url->link('extension/shipping/chronepostpickuppt/populate_data', 'user_token=' . $this->session->data['user_token'], true);

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_shipping'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/shipping/chronepostpickuppt', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/shipping/chronepostpickuppt', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=shipping', true);

		if (isset($this->request->post['shipping_chronepostpickuppt_freelimit'])) {
			$data['shipping_chronepostpickuppt_freelimit'] = $this->request->post['shipping_chronepostpickuppt_freelimit'];
		} else {
			$data['shipping_chronepostpickuppt_freelimit'] = $this->config->get('shipping_chronepostpickuppt_freelimit');
		}

		if (isset($this->request->post['shipping_chronepostpickuppt_weight_data'])) {
			$data['shipping_chronepostpickuppt_weight_data'] = $this->request->post['shipping_chronepostpickuppt_weight_data'];
		} else {
			$data['shipping_chronepostpickuppt_weight_data'] = $this->config->get('shipping_chronepostpickuppt_weight_data');
		}

		if (isset($this->request->post['shipping_chronepostpickuppt_tax_class_id'])) {
			$data['shipping_chronepostpickuppt_tax_class_id'] = $this->request->post['shipping_chronepostpickuppt_tax_class_id'];
		} else {
			$data['shipping_chronepostpickuppt_tax_class_id'] = $this->config->get('shipping_chronepostpickuppt_tax_class_id');
		}

		$this->load->model('localisation/tax_class');

		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		if (isset($this->request->post['shipping_chronepostpickuppt_geo_zone_id'])) {
			$data['shipping_chronepostpickuppt_geo_zone_id'] = $this->request->post['shipping_chronepostpickuppt_geo_zone_id'];
		} else {
			$data['shipping_chronepostpickuppt_geo_zone_id'] = $this->config->get('shipping_chronepostpickuppt_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['shipping_chronepostpickuppt_status'])) {
			$data['shipping_chronepostpickuppt_status'] = $this->request->post['shipping_chronepostpickuppt_status'];
		} else {
			$data['shipping_chronepostpickuppt_status'] = $this->config->get('shipping_chronepostpickuppt_status');
		}

		if (isset($this->request->post['shipping_chronepostpickuppt_sort_order'])) {
			$data['shipping_chronepostpickuppt_sort_order'] = $this->request->post['shipping_chronepostpickuppt_sort_order'];
		} else {
			$data['shipping_chronepostpickuppt_sort_order'] = $this->config->get('shipping_chronepostpickuppt_sort_order');
		}

		$sql = 'SELECT * FROM ' . DB_PREFIX . 'xx_chronepostpickuppt_shops ORDER BY location, name, address, postal_code';
		$query = $this->db->query($sql);
		foreach ($query->rows as $result) {
			$data['chronepostpickuppt_places'][$result['pickme_id']] = array(
				'dickup_place' => $result['name'] . ' (' . $result['address'] . ', ' . $result['postal_code'] . ')',
				'dickup_region' => $result['location']
			);
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/shipping/chronepostpickuppt', $data));
	}

	public function install()
	{
		$this->db->query("
			CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xx_chronepostpickuppt_shops` (
			    `id_pickme_shop` int(10) unsigned NOT NULL auto_increment,
				`pickme_id` varchar(30) NULL,
				`name` varchar(255) NULL,
				`address` varchar(1000) NULL,
				`location` varchar(400) NULL,
				`postal_code` varchar(20) NULL,
			  PRIMARY KEY  (`id_pickme_shop`)
			) ENGINE=MyISAM DEFAULT COLLATE=utf8_general_ci AUTO_INCREMENT=1;
		");
		$this->refresh_data();
	}

	public function uninstall()
	{
		$this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "xx_chronepostpickuppt_shops`");
	}

	public function XmlLoader($strXml)
	{
		set_error_handler(function ($number, $error) {
			if (preg_match('/^DOMDocument::loadXML\(\): (.+)$/', $error, $m) === 1) {
				throw new Exception($m[1]);
			}
		});
		$dom = new DOMDocument();
		$dom->loadXml($strXml);
		restore_error_handler();
		return $dom;
	}

	public function refresh_data()
	{

		$context = stream_context_create(
			array(
				'ssl' => array(
					'verify_peer' => false,
					'allow_self_signed' => true
				)
			)
		);
		$client = new SoapClient(
			'http://83.240.239.170:7790/ChronoWSB2CPointsv3/GetB2CPoints_v3Service?wsdl',
			array(
				'stream_context' => $context
			)
		);

		$this->db->query("DELETE FROM `" . DB_PREFIX . "xx_chronepostpickuppt_shops`");

		$result = $client->getPointList_V3();
		foreach ($result->return->lB2CPointsArr as $message) {
			$query = '
		        INSERT INTO `' . DB_PREFIX . 'xx_chronepostpickuppt_shops`
		               (pickme_id, name, address, postal_code, location)
		        VALUES ("' . $message->Number . '", "' . $message->Name . '", "' . $message->Address . '", "' . $message->PostalCode . '", "' . $message->PostalCodeLocation . '")';
			$this->db->query($query);
		}
	}

	public function populate_data()
	{
		$this->refresh_data();
		$this->index();
	}

	protected function validate()
	{
		if (!$this->user->hasPermission('modify', 'extension/shipping/chronepostpickuppt')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
