<?php 
class ModelExtensionModuleOrderSuccessPage extends Model {	
    private $eventGroup = 'isenselabs_ordersuccesspage';
    private $modulePath;

    public function __construct($registry) {
        parent::__construct($registry);
        $this->config->load('isenselabs/ordersuccesspage');
        $this->load->model('setting/event');
        $this->modulePath = $this->config->get('ordersuccesspage_modulePath');
    }

    public function setupEventHandlers() {
        $this->removeEventHandlers();
        $this->model_setting_event->addEvent($this->eventGroup, "catalog/controller/checkout/success/before", $this->modulePath . '/captureOrderId');
        $this->model_setting_event->addEvent($this->eventGroup, "catalog/view/common/success/before", $this->modulePath);
    }

    public function removeEventHandlers() {
        $this->model_setting_event->deleteEventByCode($this->eventGroup);
    }
}
