<?php

/**
 * Class ControllerExtensionModuleOclayerednavigation
 * @property ModelExtensionModuleOcLayeredNavigation $model_extension_module_oclayerednavigation
 */
class ControllerExtensionModuleOclayerednavigation extends Controller
{
    /**
     * Load layered navigation block
     */
    public function index()
    {
        $this->load->language('extension/module/oclayerednavigation');
        $this->load->model('catalog/manufacturer');
        $data = array();

        if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') {
            // SSL connection
            $base_url = str_replace('http', 'https', $this->config->get('config_url'));
        } else {
            $base_url = $this->config->get('config_url');
        }

        if (isset($this->request->get['manufacturer_id'])) {
            $manufacturer_id = (int)$this->request->get['manufacturer_id'];
            $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);

            if ($manufacturer_info) {

                $url = '';

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . explode(',', $this->request->get['option']);
                    $data['filter_option'] = explode(',', $this->request->get['option']);
                } else {
                    $data['filter_option'] = array();
                }

                $data['action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . $url);
                $data['clear_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id);

                $this->load->model('extension/module/oclayerednavigation');

                $results = $this->model_extension_module_oclayerednavigation->getManufacturerMinMaxPrice($manufacturer_id);

                $min_price = (float)$results['min'] > 0 ? $results['min'] : 1;
                $max_price = $results['max'];

                $rate = (float)$this->currency->getValue($this->session->data['currency']);

                $data['min_price'] = ceil($min_price * $rate);
                $data['max_price'] = round($max_price * $rate);

                $data['currency_symbol_left'] = $this->currency->getSymbolLeft($this->session->data['currency']);
                $data['currency_symbol_right'] = $this->currency->getSymbolRight($this->session->data['currency']);

                $data['filter_groups'] = array();

                /* Brands and option auto filters */
                $filter_data = array(
                    'filter_manufacturer_id' => $manufacturer_id,
					'sort' => 'p.date_added',
					'order' => 'DESC'
                );

                $products_arr_info = $this->model_catalog_product->getProducts($filter_data);

                if (count($products_arr_info) > 0) {
                    $products_arr_id = [];
                    foreach ($products_arr_info as $item) {
                        $products_arr_id[] = $item['product_id'];
                    }

                    $option_all = $this->model_extension_module_oclayerednavigation->getAllOptions($products_arr_id);

                    foreach ($option_all as $k => $opt) {
                        $data['filter_groups'][] = array(
                            'name' => $k,
                            'type' => 'option',
                            'filter' => $opt
                        );
                    }
                }
            }
        } else {
            if (isset($this->request->get['path'])) {
                $parts = explode('_', (string)$this->request->get['path']);
            } else {
                $parts = array();
            }

            $category_id = end($parts);

            $this->load->model('catalog/category');

            $category_info = $this->model_catalog_category->getCategory($category_id);

            if ($category_info) {

                $url = '';

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                if (isset($this->request->get['manufacturer'])) {
                    $url .= '&manufacturer=' . explode(',', $this->request->get['manufacturer']);
                    $data['filter_manufacturer'] = explode(',', $this->request->get['manufacturer']);
                } else {
                    $data['filter_manufacturer'] = array();
                }

                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . explode(',', $this->request->get['option']);
                    $data['filter_option'] = explode(',', $this->request->get['option']);
                } else {
                    $data['filter_option'] = array();
                }

                $data['action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . $url);
                $data['clear_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id);

                $this->load->model('extension/module/oclayerednavigation');

                $results = $this->model_extension_module_oclayerednavigation->getMinMaxPrice($category_id);

                $min_price = (float)$results['min'] > 0 ? $results['min'] : 1;
                $max_price = $results['max'];

                $rate = (float)$this->currency->getValue($this->session->data['currency']);

                $data['min_price'] = ceil($min_price * $rate);
                $data['max_price'] = round($max_price * $rate);

                $data['currency_symbol_left'] = $this->currency->getSymbolLeft($this->session->data['currency']);
                $data['currency_symbol_right'] = $this->currency->getSymbolRight($this->session->data['currency']);

                $data['filter_groups'] = array();

                /* Brands and option auto filters */
                $filter_data = array(
                    'filter_category_id' => $category_id,
					'sort' => 'p.date_added',
					'order' => 'DESC'
                );

                $products_arr_info = $this->model_catalog_product->getProducts($filter_data);

                if (count($products_arr_info) > 0) {
                    $products_arr_id = [];
                    foreach ($products_arr_info as $item) {
                        $products_arr_id[] = $item['product_id'];
                    }
                    $manufacturer_all = $this->model_extension_module_oclayerednavigation->getAllManufacturerId($products_arr_id);

                    $data['filter_groups'][] = array(
                        'name' => $this->language->get('text_manufacturer'),
                        'type' => 'manufacturer',
                        'filter' => $manufacturer_all
                    );
                    $option_all = $this->model_extension_module_oclayerednavigation->getAllOptions($products_arr_id);

                    foreach ($option_all as $k => $opt) {
                        $data['filter_groups'][] = array(
                            'name' => $k,
                            'type' => 'option',
                            'filter' => $opt
                        );
                    }
                }
            }
        }

        return $this->load->view('extension/module/oclayerednavigation/oclayerednavigation', $data);
    }


    /**
     * Load Layer after filter
     */
    public function layer()
    {
        if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') {
            // SSL connection
            $base_url = str_replace('http', 'https', $this->config->get('config_url'));
        } else {
            $base_url = $this->config->get('config_url');
        }
        $this->load->language('extension/module/oclayerednavigation');
        $this->load->model('catalog/manufacturer');


        if (isset($this->request->get['brand'])) {
            $manufacturer_id = (int)$this->request->get['brand'];
            $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);

            if ($manufacturer_info) {

                $data['clear_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id);

                if (isset($this->request->get['option'])) {
                    $data['filter_option'] = explode(',', $this->request->get['option']);
                } else {
                    $data['filter_option'] = array();
                }

                $this->load->model('catalog/product');

                $rate = (float)$this->currency->getValue($this->session->data['currency']);

                $this->load->model('extension/module/oclayerednavigation');
                $results = $this->model_extension_module_oclayerednavigation->getManufacturerMinMaxPrice($manufacturer_id);

                $min_price = (float)$results['min'] > 0 ? $results['min'] : 1;
                $max_price = $results['max'];

                $data['min_price'] = ceil($min_price * $rate);
                $data['max_price'] = round($max_price * $rate);

                if (isset($this->request->get['price'])) {
                    $price_data = $this->request->get['price'];
                } else {
                    $price_data = '';
                }

                if (isset($this->request->get['price'])) {
                    $price_data = explode(',', $price_data);
                    $data['current_min_price'] = $price_data[0];
                    $data['current_max_price'] = $price_data[1];
                } else {
                    $data['current_min_price'] = $data['min_price'];
                    $data['current_max_price'] = $data['max_price'];
                }

                $data['currency_symbol_left'] = $this->currency->getSymbolLeft($this->session->data['currency']);
                $data['currency_symbol_right'] = $this->currency->getSymbolRight($this->session->data['currency']);
                /* End */

                $data['filter_groups'] = array();

                /* Brands and option auto filters */
                $filter_data = array(
                    'filter_manufacturer_id' => $manufacturer_id,
					'sort' => 'p.date_added',
					'order' => 'DESC'
                );

                $products_arr_info = $this->model_catalog_product->getProducts($filter_data);

                if (count($products_arr_info) > 0) {
                    $products_arr_id = [];
                    foreach ($products_arr_info as $item) {
                        $products_arr_id[] = $item['product_id'];
                    }

                    $option_all = $this->model_extension_module_oclayerednavigation->getAllOptions($products_arr_id);

                    foreach ($option_all as $k => $opt) {
                        $data['filter_groups'][] = array(
                            'name' => $k,
                            'type' => 'option',
                            'filter' => $opt
                        );
                    }
                }
            }
        } else {
            if (isset($this->request->get['path'])) {
                $parts = explode('_', (string)$this->request->get['path']);
            } else {
                $parts = array();
            }

            $category_id = end($parts);

            $this->load->model('catalog/category');

            $category_info = $this->model_catalog_category->getCategory($category_id);

            if ($category_info) {

                $data['clear_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id);

                if (isset($this->request->get['manufacturer'])) {
                    $data['filter_manufacturer'] = explode(',', $this->request->get['manufacturer']);
                } else {
                    $data['filter_manufacturer'] = array();
                }

                if (isset($this->request->get['option'])) {
                    $data['filter_option'] = explode(',', $this->request->get['option']);
                } else {
                    $data['filter_option'] = array();
                }

                $this->load->model('catalog/product');

                $rate = (float)$this->currency->getValue($this->session->data['currency']);

                $this->load->model('extension/module/oclayerednavigation');
                $results = $this->model_extension_module_oclayerednavigation->getMinMaxPrice($category_id);

                $min_price = (float)$results['min'] > 0 ? $results['min'] : 1;
                $max_price = $results['max'];

                $data['min_price'] = ceil($min_price * $rate);
                $data['max_price'] = round($max_price * $rate);

                if (isset($this->request->get['price'])) {
                    $price_data = $this->request->get['price'];
                } else {
                    $price_data = '';
                }

                if (isset($this->request->get['price'])) {
                    $price_data = explode(',', $price_data);
                    $data['current_min_price'] = $price_data[0];
                    $data['current_max_price'] = $price_data[1];
                } else {
                    $data['current_min_price'] = $data['min_price'];
                    $data['current_max_price'] = $data['max_price'];
                }

                $data['currency_symbol_left'] = $this->currency->getSymbolLeft($this->session->data['currency']);
                $data['currency_symbol_right'] = $this->currency->getSymbolRight($this->session->data['currency']);
                /* End */

                $data['filter_groups'] = array();

                /* Brands and option auto filters */
                $filter_data = array(
                    'filter_category_id' => $category_id,
					'sort' => 'p.date_added',
					'order' => 'DESC'
                );

                $products_arr_info = $this->model_catalog_product->getProducts($filter_data);

                if (count($products_arr_info) > 0) {
                    $products_arr_id = [];
                    foreach ($products_arr_info as $item) {
                        $products_arr_id[] = $item['product_id'];
                    }
                    $manufacturer_all = $this->model_extension_module_oclayerednavigation->getAllManufacturerId($products_arr_id);

                    $data['filter_groups'][] = array(
                        'name' => $this->language->get('text_manufacturer'),
                        'type' => 'manufacturer',
                        'filter' => $manufacturer_all
                    );
                    $option_all = $this->model_extension_module_oclayerednavigation->getAllOptions($products_arr_id);

                    foreach ($option_all as $k => $opt) {
                        $data['filter_groups'][] = array(
                            'name' => $k,
                            'type' => 'option',
                            'filter' => $opt
                        );
                    }
                }
            }
        }
        return $this->load->view('extension/module/oclayerednavigation/oclayerednavigationfilter', $data);
    }

    /**
     * Load category view
     */
    public function category()
    {
        $this->load->language('product/category');
        $this->load->model('catalog/manufacturer');
        $this->load->model('catalog/category');
        $this->load->model('catalog/product');
        $this->load->model('tool/image');


        if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') {
            // SSL connection
            $base_url = str_replace('http', 'https', $this->config->get('config_url'));
        } else {
            $base_url = $this->config->get('config_url');
        }

        $json = array();

        if (isset($this->request->get['price'])) {
            $price_data = $this->request->get['price'];
        } else {
            $price_data = '';
        }

        if (isset($this->request->get['filter'])) {
            $filter = $this->request->get['filter'];
        } else {
            $filter = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'p.date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['limit'])) {
            $limit = $this->request->get['limit'];
        } else {
            $limit = $this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit');
        }

        if (isset($this->request->get['brand'])) {
            $manufacturer_id = (int)$this->request->get['brand'];
            $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);

            if ($manufacturer_info) {
                $data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));

                if ($manufacturer_info['image']) {
                    $data['thumb'] = $this->model_tool_image->resize($manufacturer_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_height'));
                } else {
                    $data['thumb'] = '';
                }

                $data['description'] = html_entity_decode($manufacturer_info['description'], ENT_QUOTES, 'UTF-8');
                $data['compare'] = $this->url->link('product/compare');

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                /* option filter */
                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . $this->request->get['option'];
                }
                /* -- end option filter */

                // Quick View & Rotator
                $store_id = $this->config->get('config_store_id');
                $data['use_quickview'] = (int)$this->config->get('module_octhemeoption_quickview')[$store_id];
                $product_rotator_status = (int)$this->config->get('module_octhemeoption_rotator')[$store_id];

                /* Get new product */
                $this->load->model('catalog/product');
                $new_results = $this->model_catalog_product->getLatestProducts(30);
                /* End */

                $data['products'] = array();

                $rate = (float)$this->currency->getValue($this->session->data['currency']);

                // Min and Max Price
                $filter_price = array();
                if (isset($this->request->get['price'])) {
                    $price_data = explode(',', $price_data);
                    $filter_price['min_price'] = ceil($price_data[0] / $rate - 1);
                    $filter_price['max_price'] = round($price_data[1] / $rate);
                }

                $filter_data = array(
                    'filter_manufacturer_id' => $manufacturer_id,
                    'filter_filter' => $filter,
                    'filter_price' => $filter_price,
                    'sort' => $sort,
                    'order' => $order,
                    'start' => ($page - 1) * $limit,
                    'limit' => $limit
                );

                /* option filter */
                if (isset($this->request->get['option'])) {
                    $filter_data['filter_option'] = $this->request->get['option'];
                }
                /* -- end option filter */
                $product_total = $this->model_catalog_product->getTotalProducts($filter_data);
                $results = $this->model_catalog_product->getProducts($filter_data);

                foreach ($results as $result) {
                    if ($result['image']) {
                        $image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
                    } else {
                        $image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
                    }

                    if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $price = false;
                    }

                    if ((float)$result['special']) {
                        $special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $special = false;
                    }

                    if ($this->config->get('config_tax')) {
                        $tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
                    } else {
                        $tax = false;
                    }

                    if ($this->config->get('config_review_status')) {
                        $rating = (int)$result['rating'];
                    } else {
                        $rating = false;
                    }

                    // Add Rotator
                    if ($product_rotator_status == 1) {
                        $this->load->model('catalog/ocproductrotator');
                        $this->load->model('tool/image');

                        $product_id = $result['product_id'];
                        $product_rotator_image = $this->model_catalog_ocproductrotator->getProductRotatorImage($product_id);

                        if ($product_rotator_image) {
                            $rotator_image_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
                            $rotator_image_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
                            $rotator_image = $this->model_tool_image->resize($product_rotator_image, $rotator_image_width, $rotator_image_height);
                        } else {
                            $rotator_image = false;
                        }
                    } else {
                        $rotator_image = false;
                    }

                    $is_new = false;

                    if ($new_results) {
                        foreach ($new_results as $new_r) {
                            if ($result['product_id'] == $new_r['product_id']) {
                                $is_new = true;
                            }
                        }
                    }

                    $data['products'][] = array(
                        'is_new' => $is_new,
                        'rotator_image' => $rotator_image,
                        'product_id' => $result['product_id'],
                        'thumb' => $image,
                        'name' => $result['name'],
                        'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
                        'price' => $price,
                        'special' => $special,
                        'tax' => $tax,
                        'minimum' => $result['minimum'] > 0 ? $result['minimum'] : 1,
                        'rating' => $rating,
                        'href' => $this->url->link('product/product', 'path=' . $this->request->get['path'] . '&product_id=' . $result['product_id']),
                        'manufacturer' => $result['manufacturer'],
                        'manufacturers' => $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $result['manufacturer_id']),
                    );
                }

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                $data['sorts'] = array();

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_default'),
                    'value' => 'p.sort_order-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=p.sort_order&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_name_asc'),
                    'value' => 'pd.name-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=pd.name&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_name_desc'),
                    'value' => 'pd.name-DESC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=pd.name&order=DESC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_price_asc'),
                    'value' => 'p.price-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=p.price&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_price_desc'),
                    'value' => 'p.price-DESC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=p.price&order=DESC' . $url
                );

                if ($this->config->get('config_review_status')) {
                    $data['sorts'][] = array(
                        'text' => $this->language->get('text_rating_desc'),
                        'value' => 'rating-DESC',
                        'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=rating&order=DESC' . $url
                    );

                    $data['sorts'][] = array(
                        'text' => $this->language->get('text_rating_asc'),
                        'value' => 'rating-ASC',
                        'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=rating&order=ASC' . $url
                    );
                }

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_model_asc'),
                    'value' => 'p.model-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=p.model&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_model_desc'),
                    'value' => 'p.model-DESC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . '&sort=p.model&order=DESC' . $url
                );

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                /* option filter */
                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . $this->request->get['option'];
                }
                /* -- end manufacturer filter */

                $data['limits'] = array();

                $limits = array_unique(array($this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit'), 25, 50, 75, 100));

                sort($limits);

                foreach ($limits as $value) {
                    $data['limits'][] = array(
                        'text' => $value,
                        'value' => $value,
                        'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . $url . '&limit=' . $value
                    );
                }

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }


                /* option filter */
                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . $this->request->get['option'];
                }
                /* -- end manufacturer filter */

                $pagination = new Pagination();
                $pagination->total = $product_total;
                $pagination->page = $page;
                $pagination->num_links = 4;
                $pagination->limit = $limit;
                $pagination->url = $base_url . 'index.php?route=product/category&brand=' . $manufacturer_id . $url . '&amp;page={page}';

                $data['pagination'] = $pagination->render();

                $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($product_total - $limit)) ? $product_total : ((($page - 1) * $limit) + $limit), $product_total, ceil($product_total / $limit));

                if ($limit && ceil($product_total / $limit) > $page) {
                    $this->document->addLink($this->url->link('product/category', 'path=' . $manufacturer_info['category_id'] . '&page=' . ($page + 1), true), 'next');
                }

                $data['sort'] = $sort;
                $data['order'] = $order;
                $data['limit'] = $limit;

                $json['result_html'] = $this->load->view('extension/module/oclayerednavigation/occategoryfilter', $data);

                $url = '';

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                $json['filter_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . $url);

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                $json['price_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&brand=' . $manufacturer_id . $url);
                $json['layered_html'] = $this->layer();
            } else {
                $json['result_html'] = "No No No";
            }
        } else {
            if (isset($this->request->get['path'])) {
                $parts = explode('_', (string)$this->request->get['path']);
                $category_id = (int)array_pop($parts);
            } else {
                $category_id = 0;
            }

            $category_info = $this->model_catalog_category->getCategory($category_id);

            if ($category_info) {
                $data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));

                if ($category_info['image']) {
                    $data['thumb'] = $this->model_tool_image->resize($category_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_height'));
                } else {
                    $data['thumb'] = '';
                }

                $data['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
                $data['compare'] = $this->url->link('product/compare');

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                /* manufacturer filter */
                if (isset($this->request->get['manufacturer'])) {
                    $url .= '&manufacturer=' . $this->request->get['manufacturer'];
                }
                /* -- end manufacturer filter */

                /* option filter */
                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . $this->request->get['option'];
                }
                /* -- end manufacturer filter */

                $data['categories'] = array();

                $results = $this->model_catalog_category->getCategories($category_id);

                foreach ($results as $result) {
                    $filter_data = array(
                        'filter_category_id' => $result['category_id'],
                        'filter_sub_category' => true
                    );

                    $data['categories'][] = array(
                        'name' => $result['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
                        'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $result['category_id'] . $url
                    );
                }

                // Quick View & Rotator
                $store_id = $this->config->get('config_store_id');
                $data['use_quickview'] = (int)$this->config->get('module_octhemeoption_quickview')[$store_id];
                $product_rotator_status = (int)$this->config->get('module_octhemeoption_rotator')[$store_id];

                /* Get new product */
                $this->load->model('catalog/product');
                $new_results = $this->model_catalog_product->getLatestProducts(30);
                /* End */

                $data['products'] = array();

                $rate = (float)$this->currency->getValue($this->session->data['currency']);

                // Min and Max Price
                $filter_price = array();
                if (isset($this->request->get['price'])) {
                    $price_data = explode(',', $price_data);
                    $filter_price['min_price'] = ceil($price_data[0] / $rate - 1);
                    $filter_price['max_price'] = round($price_data[1] / $rate);
                }

                $filter_data = array(
                    'filter_category_id' => $category_id,
                    'filter_filter' => $filter,
                    'filter_price' => $filter_price,
                    'sort' => $sort,
                    'order' => $order,
                    'start' => ($page - 1) * $limit,
                    'limit' => $limit
                );

                /* manufacturer filter */
                if (isset($this->request->get['manufacturer'])) {
                    $filter_data['filter_manufacturer_id'] = $this->request->get['manufacturer'];
                }
                /* -- end manufacturer filter */

                /* option filter */
                if (isset($this->request->get['option'])) {
                    $filter_data['filter_option'] = $this->request->get['option'];
                }
                /* -- end option filter */
                $product_total = $this->model_catalog_product->getTotalProducts($filter_data);
                $results = $this->model_catalog_product->getProducts($filter_data);

                foreach ($results as $result) {
                    if ($result['image']) {
                        $image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
                    } else {
                        $image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
                    }

                    if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $price = false;
                    }

                    if ((float)$result['special']) {
                        $special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $special = false;
                    }

                    if ($this->config->get('config_tax')) {
                        $tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
                    } else {
                        $tax = false;
                    }

                    if ($this->config->get('config_review_status')) {
                        $rating = (int)$result['rating'];
                    } else {
                        $rating = false;
                    }

                    // Add Rotator
                    if ($product_rotator_status == 1) {
                        $this->load->model('catalog/ocproductrotator');
                        $this->load->model('tool/image');

                        $product_id = $result['product_id'];
                        $product_rotator_image = $this->model_catalog_ocproductrotator->getProductRotatorImage($product_id);

                        if ($product_rotator_image) {
                            $rotator_image_width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
                            $rotator_image_height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
                            $rotator_image = $this->model_tool_image->resize($product_rotator_image, $rotator_image_width, $rotator_image_height);
                        } else {
                            $rotator_image = false;
                        }
                    } else {
                        $rotator_image = false;
                    }

                    $is_new = false;

                    if ($new_results) {
                        foreach ($new_results as $new_r) {
                            if ($result['product_id'] == $new_r['product_id']) {
                                $is_new = true;
                            }
                        }
                    }

                    $data['products'][] = array(
                        'is_new' => $is_new,
                        'rotator_image' => $rotator_image,
                        'product_id' => $result['product_id'],
                        'thumb' => $image,
                        'name' => $result['name'],
                        'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
                        'price' => $price,
                        'special' => $special,
                        'tax' => $tax,
                        'minimum' => $result['minimum'] > 0 ? $result['minimum'] : 1,
                        'rating' => $result['rating'],
                        'href' => $this->url->link('product/product', 'path=' . $this->request->get['path'] . '&product_id=' . $result['product_id']),
                        'manufacturer' => $result['manufacturer'],
                        'manufacturers' => $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $result['manufacturer_id']),
                    );
                }

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                $data['sorts'] = array();

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_default'),
                    'value' => 'p.sort_order-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=p.sort_order&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_name_asc'),
                    'value' => 'pd.name-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=pd.name&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_name_desc'),
                    'value' => 'pd.name-DESC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=pd.name&order=DESC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_price_asc'),
                    'value' => 'p.price-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=p.price&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_price_desc'),
                    'value' => 'p.price-DESC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=p.price&order=DESC' . $url
                );

                if ($this->config->get('config_review_status')) {
                    $data['sorts'][] = array(
                        'text' => $this->language->get('text_rating_desc'),
                        'value' => 'rating-DESC',
                        'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=rating&order=DESC' . $url
                    );

                    $data['sorts'][] = array(
                        'text' => $this->language->get('text_rating_asc'),
                        'value' => 'rating-ASC',
                        'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=rating&order=ASC' . $url
                    );
                }

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_model_asc'),
                    'value' => 'p.model-ASC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=p.model&order=ASC' . $url
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_model_desc'),
                    'value' => 'p.model-DESC',
                    'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . '&sort=p.model&order=DESC' . $url
                );

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                /* manufacturer filter */
                if (isset($this->request->get['manufacturer'])) {
                    $url .= '&manufacturer=' . $this->request->get['manufacturer'];
                }
                /* -- end manufacturer filter */

                /* option filter */
                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . $this->request->get['option'];
                }
                /* -- end manufacturer filter */

                $data['limits'] = array();

                $limits = array_unique(array($this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit'), 25, 50, 75, 100));

                sort($limits);

                foreach ($limits as $value) {
                    $data['limits'][] = array(
                        'text' => $value,
                        'value' => $value,
                        'href' => $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . $url . '&limit=' . $value
                    );
                }

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }


                /* manufacturer filter */
                if (isset($this->request->get['manufacturer'])) {
                    $url .= '&manufacturer=' . $this->request->get['manufacturer'];
                }
                /* -- end manufacturer filter */

                /* option filter */
                if (isset($this->request->get['option'])) {
                    $url .= '&option=' . $this->request->get['option'];
                }
                /* -- end manufacturer filter */

                $pagination = new Pagination();
                $pagination->total = $product_total;
                $pagination->page = $page;
                $pagination->num_links = 4;
                $pagination->limit = $limit;
                $pagination->url = $base_url . 'index.php?route=product/category&path=' . $category_id . $url . '&amp;page={page}';

                $data['pagination'] = $pagination->render();

                $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($product_total - $limit)) ? $product_total : ((($page - 1) * $limit) + $limit), $product_total, ceil($product_total / $limit));

                if ($limit && ceil($product_total / $limit) > $page) {
                    $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'] . '&page=' . ($page + 1), true), 'next');
                }

                $data['sort'] = $sort;
                $data['order'] = $order;
                $data['limit'] = $limit;

                $json['result_html'] = $this->load->view('extension/module/oclayerednavigation/occategoryfilter', $data);

                $url = '';

                if (isset($this->request->get['price'])) {
                    $url .= '&price=' . $this->request->get['price'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                $json['filter_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . $url);

                $url = '';

                if (isset($this->request->get['filter'])) {
                    $url .= '&filter=' . $this->request->get['filter'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit=' . $this->request->get['limit'];
                }

                $json['price_action'] = str_replace('&amp;', '&', $base_url . 'index.php?route=extension/module/oclayerednavigation/category&path=' . $category_id . $url);
                $json['layered_html'] = $this->layer();
            } else {
                $json['result_html'] = "No No No";
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}