<?php
class ControllerExtensionModuleOrderSuccessPage extends Controller {
    public static $order_id = 0;

    private $moduleVersion;
    private $moduleName;
    private $callModel;
    private $modulePath;
    private $moduleModel;

    public function __construct($registry) {
        parent::__construct($registry);
        $this->config->load('isenselabs/ordersuccesspage');
        $this->moduleVersion = $this->config->get('ordersuccesspage_moduleVersion');        
        $this->moduleName        = $this->config->get('ordersuccesspage_moduleName');        
        $this->callModel         = $this->config->get('ordersuccesspage_callModel');
        $this->modulePath        = $this->config->get('ordersuccesspage_modulePath');

        $this->load->model($this->modulePath);
        $this->moduleModel       = $this->{$this->callModel};
        $this->load->language($this->modulePath);

        if (!empty($this->session->data['osp_order_id'])) {
            self::$order_id = $this->session->data['osp_order_id'];
        }
    }

    public function index($eventRoute, $data, $template) {
        $OSP = $this->config->get('ordersuccesspage');
        $current_language = $this->config->get('config_language_id');

        if (isset($OSP['Enabled']) && $OSP['Enabled'] == 'yes' && self::$order_id != 0) {
            $this->load->model('checkout/order');
            $this->load->language('account/order');
            $this->load->language('checkout/order');

            $data['osp_order_id'] = self::$order_id;
            $data['current_language'] = $this->config->get('config_language_id');

            if (isset($OSP['PageTitle'][$current_language])) {
                $this->document->setTitle($OSP['PageTitle'][$current_language]);
                $data['heading_title'] = $OSP['PageTitle'][$current_language];
                $data['header'] = $this->load->controller('common/header');
            }	

            $language_array = array('text_order_detail', 'text_invoice_no', 'text_order_id', 'text_date_added', 'text_shipping_method', 'text_shipping_address', 'text_payment_method', 'text_payment_address', 'text_payment_address', 'text_history', 'text_comment', 'column_name', 'column_model', 'column_quantity', 'column_price', 'column_total', 'column_action', 'column_date_added', 'column_status', 'column_comment', 'text_tax', 'button_cart', 'button_wishlist', 'button_compare');

            foreach ($language_array as $lang) {
                $data[$lang] = $this->language->get($lang);
            }

            $data['OSP_orderdata']		= $this->model_checkout_order->getOrder(self::$order_id);
            $data['OSP'] 				= $this->moduleModel->getMessage($OSP, $data['OSP_orderdata'], $current_language);
            $data['promoted_products'] 	= $this->moduleModel->getPromotedProducts($OSP, $data['OSP_orderdata']);
            $data['OSP_orderinfo']		= $this->moduleModel->getOrderData($data['OSP_orderdata']);
            $data['OSP_settings']		= $this->config->get('ordersuccesspage');

            if (!empty($data['OSP']['CustomJS'])) {
                $original = array('{order_id}', '{order_total}');
                $replace = array(self::$order_id, $data['OSP_orderdata']['total']);
                $data['OSP']['CustomJS'] = str_replace($original, $replace, $data['OSP']['CustomJS']);
            }

            //Journal specific vars
            if (is_object($this->journal2)) {
                $data['journal_product_grid_classes'] = $this->journal2->settings->get('product_grid_classes');
                $data['journal_product_grid_wishlist_icon_display'] = $this->journal2->settings->get('product_grid_wishlist_icon_display');
                $data['journal_product_grid_wishlist_icon_position'] = $this->journal2->settings->get('product_grid_wishlist_icon_position');
                $data['journal_product_grid_button_block_button'] = $this->journal2->settings->get('product_grid_button_block_button');
                $data['journal_product_dummy_image'] = $this->journal2->settings->get('product_dummy_image');
                $data['journal_enquiry_popup_code'] = $this->journal2->settings->get('enquiry_popup_code');
                $data['journal_enquiry_button_text'] = $this->journal2->settings->get('enquiry_button_text');
                $data['journal_enquiry_button_icon'] = $this->journal2->settings->get('enquiry_button_icon');

                if (!empty($data['promoted_products'])) {
                    foreach ($data['promoted_products'] as &$product) {
                        if (!empty($product['labels'])) {
                            foreach ($product['labels'] as $label => $name) {
                                if ($label == 'outofstock') {
                                    $product['labels'][$label] = array(
                                        'name' => $name,
                                        'ribbon_size' => Journal2Utils::getRibbonSize($this->journal2->settings->get('out_of_stock_ribbon_size')),
                                        'ribbon' => Journal2Utils::generateRibbon($name, $this->journal2->settings->get('out_of_stock_ribbon_size'), $this->journal2->settings->get('out_of_stock_font_color'), $this->journal2->settings->get('out_of_stock_bg'))
                                    );
                                } else {
                                    $product['labels'][$label] = array('name' => $name);
                                }
                            }
                        }

                        $product['isEnquiryProduct'] = Journal2Utils::isEnquiryProduct($this, $product['product_id']);
                    }
                }
            }

            return $this->load->view($this->modulePath, $data);
        }
    }

    public function captureOrderId() {
        if (!empty($this->session->data['order_id'])) {
            self::$order_id = (int)$this->session->data['order_id'];
            $this->session->data['osp_order_id'] = self::$order_id;
        }
    }
}
