<?php

class ControllerExtensionModuleSosearchpro extends Controller
{

    private $data = array();

    //=== Theme Custom Code====

    public function getProducts($setting) {
        $filter_data = array(
            'sort' => 'p.viewed',
            'order' => 'DESC',
            'limit' => $setting['limit_keyword'],
            'start' => '0'
        );
        $data['products'] = array();
        $data['list_products'] = array();
        $products_arr = $this->model_extension_module_so_searchpro->getProducts($filter_data);

        foreach ($products_arr as $product_info) {
            // Name
            $name = $product_info['name'];
            $name_maxlength = ((strlen($product_info['name']) > 25) ? utf8_substr(strip_tags(html_entity_decode($product_info['name'], ENT_QUOTES, 'UTF-8')), 0, 25) . '..' : $product_info['name']);
            $data['list_products'][] = array(
                'product_id' => $product_info['product_id'],
                'name' => $name,
                'nameFull' => $product_info['name'],
                'name_maxlength' => $name_maxlength,
                'href' => $this->url->link('product/product', 'product_id=' . $product_info['product_id'])
            );
        }
        return $data['list_products'];
    }

    //=== End Theme Custom Code====

    public function autocomplete() {
        $json = array();

        $this->load->language('product/category');
        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_category_id'])) {
            $this->load->model('tool/image');
            $this->load->model('catalog/product');
            $this->load->model('catalog/category');

            if (isset($this->request->get['filter_name'])) {
                $filter_name = $this->request->get['filter_name'];
            } else {
                $filter_name = '';
            }

            if (isset($this->request->get['filter_category_id'])) {
                $filter_category_id = $this->request->get['filter_category_id'];
            } else {
                $filter_category_id = '';
            }

            if (isset($this->request->get['limit'])) {
                $limit = $this->request->get['limit'];
            } else {
                $limit = 20;
            }

            if (isset($this->request->get['width'])) {
                $width = $this->request->get['width'];
            } else {
                $width = 64;
            }

            if (isset($this->request->get['height'])) {
                $height = $this->request->get['height'];
            } else {
                $height = 64;
            }

            $data = array(
                'filter_name' => $filter_name,
                'filter_tag' => $filter_name,
                'filter_category_id' => $filter_category_id,
                'start' => 0,
                'limit' => $limit
            );

            $results = $this->model_catalog_product->getProducts($data);
            $total = $this->model_catalog_product->getTotalProducts($data);
            foreach ($results as $result) {
                if ($result['image']) {
                    $image = $this->model_tool_image->resize($result['image'], $width, $height);
                } else {
                    $image = false;
                }
                // Check Version
                if (version_compare(VERSION, '2.1.0.2', '>')) {
                    if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $price = false;
                    }

                    if ((float)$result['special']) {
                        $special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $special = false;
                    }

                    if ($this->config->get('config_tax')) {
                        $tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
                    } else {
                        $tax = false;
                    }

                    if ($this->config->get('config_review_status')) {
                        $rating = $result['rating'];
                    } else {
                        $rating = false;
                    }
                } else {
                    if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                        $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
                    } else {
                        $price = false;
                    }

                    if ((float)$result['special']) {
                        $special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
                    } else {
                        $special = false;
                    }

                    if ($this->config->get('config_tax')) {
                        $tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price']);
                    } else {
                        $tax = false;
                    }

                    if ($this->config->get('config_review_status')) {
                        $rating = $result['rating'];
                    } else {
                        $rating = false;
                    }
                }
                $path = 0;
                $category_name = '';
                $categories = $this->model_catalog_product->getCategories($result['product_id']);
                if ($categories) {
                    $categories_info = $this->model_catalog_category->getCategory($categories[0]['category_id']);
                    $path = $this->getCategoryPath($categories[0]['category_id']);
                    $category_name = (isset($categories_info['name']) && $categories_info['name']) ? $categories_info['name'] : '';
                }


                $json[] = array(
                    'total' => $total,
                    'product_id' => $result['product_id'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'category_name' => strip_tags(html_entity_decode($category_name, ENT_QUOTES, 'UTF-8')),
                    'model' => $result['model'],
                    'image' => $image,
                    'link' => $this->url->link('product/product', 'path=' . $path . '&product_id=' . $result['product_id']),
                    'special' => $special,
                    'tax' => $tax,
                    'price' => $price,
                    'minimum' => $result['minimum']
                );
            }

        }

        $this->response->setOutput(json_encode($json));
    }

    public function getCategoryPath($category_id) {
        $path = '';
        $category = $this->db->query("SELECT * FROM " . DB_PREFIX . "category c WHERE c.category_id = " . (int)($category_id));

        if ($category->row['parent_id'] != 0) {
            $path .= $this->getCategoryPath($category->row['parent_id']) . '_';
        }

        $path .= $category->row['category_id'];

        return $path;
    }
}

?>
