$(document).ready(function () {
	oclayerednavigationajax.productViewChange();
	oclayerednavigationajax.paginationChangeAction();
});
var oclayerednavigationajax = {
	filter: function (filter_url, skipPushState) {
		var old_route = "route=product/category";
		var new_route = "route=extension/module/oclayerednavigation/category";
		if (filter_url.search(old_route) != -1) {
			filter_url = filter_url.replace(old_route, new_route);
		}
		$.ajax({
			url: filter_url,
			type: "get",
			beforeSend: function () {
				$(".layered-navigation-block").show();
				$(".ajax-loader").show();
			},
			success: function (json) {
				$(".layer-category .toolbar").remove();
				$(".filter-url").val(filter_url);
				$(".price-url").val(json.price_action);
				$(".custom-category").html(json.result_html);
				$(".layered").html(json.layered_html);
				$(".layer-category").prepend($(".custom-category .toolbar"));
				oclayerednavigationajax.paginationChangeAction();
				oclayerednavigationajax.productViewChange();
				$(".layered-navigation-block").hide();
				$(".ajax-loader").hide();

				if (!skipPushState) {
					nhManageFilterState.pushStateToURL(filter_url);
				}
				$("html, body").animate({scrollTop: ($(".layer-category").offset().top - 50)}, 1000);
			}
		});
	}, productViewChange: function () {
		$("#list-view").click(function () {
			$(".custom-products").removeClass("custom-products-row");
			$(this).addClass("selected");
			$("#grid-view").removeClass("selected");
			$("#content .product-grid > .clearfix").remove();
			$("#content .product-grid").attr("class", "product-layout product-list col-xs-12");
			$("#content .product-list .caption").addClass("col-xs-8");
			$("#content .product-list .image").addClass("col-xs-4");
			localStorage.setItem("display", "list");
		});
		$("#grid-view").click(function () {
			$(".custom-products").addClass("custom-products-row");
			$(this).addClass("selected");
			$("#list-view").removeClass("selected");
			cols = $("#column-right, #column-left").length;
			if (cols == 2) {
				$("#content .product-layout").attr("class", "product-layout product-grid col-md-6 col-sm-6 col-xs-6 two-items");
			} else {
				if (cols == 1) {
					$("#content .product-layout").attr("class", "product-layout product-grid col-md-4 col-sm-6 col-xs-6 three-items");
				} else {
					$("#content .product-layout").attr("class", "product-layout product-grid col-md-3 col-sm-6 col-xs-6 four-items");
				}
			}
			2;
			$("#content .product-grid .caption").removeClass("col-xs-8");
			$("#content .product-grid .image").removeClass("col-xs-4");
			localStorage.setItem("display", "grid");
		});
		if (localStorage.getItem("display") == "list") {
			$("#list-view").trigger("click");
		} else {
			$("#grid-view").trigger("click");
		}
	}, paginationChangeAction: function () {
		$(".custom-category .pagination a").each(function () {
			var href = $(this).attr("href");
			$(this).attr("onclick", 'oclayerednavigationajax.filter("' + href + '")');
			$(this).attr("href", "javascript:void(0);");
		});
	}
};
$(document).ready(function () {
	nhManageFilterState.init();
});

var nhManageFilterState = {
	init: function () {
		nhManageFilterState.checkForFilterInURL();
		nhManageFilterState.bindURLChange();
	},
	bindURLChange: function () {
		window.onpopstate = function (event) {
			nhManageFilterState.checkForFilterInURL();
		};
	},
	getCurrentPathAndSearch: function (noparamsign) {
		var path = document.location.pathname;
		if (path.indexOf("index") >= 0) {
			var search = document.location.search;
			if (search.indexOf("&filter=[") >= 0) {
				search = search.split("&filter=[")[0];
			}
			return path + search + (noparamsign ? "" : "&");
		}
		return path + (noparamsign ? "" : "?");
	},
	extractFilterFromRequestURL: function (filter) {
		return filter.split("?")[1] || false;
	},
	checkForFilterInURL: function () {
		function setGlobalVars(filter) {
			var urlSearchParams = new URLSearchParams(filter);
			if (filter.indexOf("manufacturer") != -1) {
				window.manufaturers = urlSearchParams.get("manufacturer").split(",");
			}
			if (filter.indexOf("option") != -1) {
				window.options = urlSearchParams.get("option").split(",");
			}
		}

		if (document.location.search.indexOf("filter=[") < 0) {
			$(".a-filter.remove-filter").trigger("click");
			return false;
		}
		var filter = "?" + document.location.search.split("filter=[")[1].split("]")[0];

		setGlobalVars(filter);

		return nhManageFilterState.applyFilter(filter, true);
	},
	pushStateToURL: function (filter_url) {
		if (filter_url.indexOf("manufacturer") != -1 || filter_url.indexOf("option") != -1 || filter_url.indexOf("price") != -1 || filter_url.indexOf("page") != -1) {
			return history.pushState(null, "filters", nhManageFilterState.getCurrentPathAndSearch() + "filter=[" + nhManageFilterState.extractFilterFromRequestURL(filter_url) + "]");
		}
		history.pushState(null, "filters", nhManageFilterState.getCurrentPathAndSearch(true));
	},
	applyFilter: function (filter, skipPushState) {
		if (typeof oclayerednavigationajax == "undefined") {
			return false;
		}
		return oclayerednavigationajax.filter(filter, skipPushState);
	}
};