<?php
class ControllerCheckoutSuccess extends Controller {
	public function index() {

        $data['gaTracking'] = '';

        
            
            if (isset($this->session->data['order_id'])) {
            
            $order_id = $this->session->data['order_id'];
            $payment_method = $this->session->data["payment_method"]["code"];
            
            if ($this->config->get('analytics_google_status')) {
                $this->load->model('checkout/order');
                $order_info = $this->model_checkout_order->getOrderGAE($this->session->data['order_id']);

                if ($order_info) {
                    $data['gaTracking'] .= sprintf("ga('ecommerce:addTransaction', {'id': '%s', 'affiliation': '%s', 'revenue': '%s', 'shipping': '%s', 'currency': '%s'});", $order_info['order_id'], $order_info['store_name'], $order_info['total'], $order_info['shipping'], $order_info['currency_code']) . "\n";
                    foreach ($order_info['products'] as $product) {
                        $data['gaTracking'] .= sprintf("ga('ecommerce:addItem', {'id': '%s', 'name': '%s', 'sku': '%s', 'category': '%s', 'price': '%s', 'quantity': '%s', 'currency': '%s'});", $order_info['order_id'], $product['name'], $product['sku'], $product['category'], $product['price'], $product['quantity'], $order_info['currency_code']) . "\n";
                    }
                }
            }
        }
      

        
            
            $this->load->language('checkout/success');
            
            $order_id = "";
            $payment_method = "";
            
        try {
          // validates the plugin
          $facebookadsextensionFilename =
            DIR_APPLICATION . '../admin/controller/extension/facebookadsextension.php';
          if (!is_file($facebookadsextensionFilename)) {
            throw new Exception($this->language->get(
              'text_warning_facebook_missing_facebookadsextension'));
          }

          require_once $facebookadsextensionFilename;
          $facebookadsextensionController =
            new ControllerExtensionFacebookAdsExtension($this->registry);
          $all_error_messages = $facebookadsextensionController->validate();
          if (sizeof($all_error_messages) > 0) {
            throw new Exception($this->language->get(
              'text_warning_facebook_fae_install_problem'));
          }

          $this->facebookcommonutils = new FacebookCommonUtils();
          $products = $this->cart->getProducts();
          if (sizeof($products)) {
            // update the product availability on Facebook
            $this->facebookcommonutils->updateProductAvailability(
              $this->registry,
              $products);
          }
        } catch (Exception $e) {
          error_log($e->getMessage());
        }
      
		
            
            $this->load->language('checkout/success');
            
            $order_id = "";
            $payment_method = "";
            

		
            
            if (isset($this->session->data['order_id'])) {
            
            $order_id = $this->session->data['order_id'];
            $payment_method = $this->session->data["payment_method"]["code"];
            
			$this->cart->clear();

			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['guest']);
			unset($this->session->data['comment']);
			unset($this->session->data['order_id']);
			unset($this->session->data['coupon']);
			unset($this->session->data['reward']);
			unset($this->session->data['voucher']);
			unset($this->session->data['vouchers']);
			unset($this->session->data['totals']);
		}

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_basket'),
			'href' => $this->url->link('checkout/cart')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_checkout'),
			'href' => $this->url->link('checkout/checkout', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_success'),
			'href' => $this->url->link('checkout/success')
		);

		if ($this->customer->isLogged()) {
			$data['text_message'] = sprintf($this->language->get('text_customer'), $this->url->link('account/account', '', true), $this->url->link('account/order', '', true), $this->url->link('account/download', '', true), $this->url->link('information/contact'));
		} else {
			$data['text_message'] = sprintf($this->language->get('text_guest'), $this->url->link('information/contact'));
		}

		$data['continue'] = $this->url->link('common/home');

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		
            
            $data['header'] = $this->load->controller('common/header');
            
            if ($payment_method == "multibanco") {

            $this->load->model('extension/payment/multibanco');
            
            $multibanco_info = $this->model_extension_payment_multibanco->getIfthenpayData($order_id);
            
            $referencia = $multibanco_info[0]["referencia"];
            
            $referencia = substr($referencia, 0, 3) . " ". substr($referencia, 3, 3) . " " . substr($referencia, 6, 3);  
            
            $data_mb = array('entry_entidade'=>'','entry_referencia'=>'','entry_valor'=>'');
		$data_mb['entry_entidade'] .= $multibanco_info[0]["entidade"];
		$data_mb['entry_referencia'] .= $referencia;
		$data_mb['entry_valor'] .= $multibanco_info[0]["valor"];

		$mb_template = $this->load->view('extension/payment/multibanco_success', $data_mb);
		
		$data['text_message'] .= $mb_template;
		}
	   if ($payment_method == 'ifthenpaymbway') {
		$data['text_message'] .= '</br>' . $this->session->data['payment_method']['comment'];
	}
            

		$this->response->setOutput($this->load->view('common/success', $data));
	}
}